/**********
* File: CDGL_IDirect3DVolumeTexture9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DVolumeTexture9. 
					 This class is our concrete implementation of IDirect3DVolumeTexture9 interface in Direct3D9. The class IDirect3DVolumeTexture9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 17Mar05

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DVOLUMETEXTURE9_H__
#define __CDGL_IDIRECT3DVOLUMETEXTURE9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"

#include "CDGL_IDirect3DVolume9.h"

class CDGL_IDirect3DVolumeTexture9 : public IDirect3DVolumeTexture9
{

	public:
	
		CDGL_IDirect3DVolumeTexture9(IDirect3DDevice9 *in_pDevice, INT in_lWidth, UINT in_lHeight, UINT in_lDepth, UINT in_lLevels, DWORD in_lUsage, D3DFORMAT in_Format, D3DPOOL in_Pool);
		~CDGL_IDirect3DVolumeTexture9();
		
		/*** IUnknown methods ***/
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();

		
		/*** IDirect3DResource9 methods ***/
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		HRESULT SetPrivateData( REFGUID refguid,CONST void* pData,DWORD SizeOfData,DWORD Flags);
		HRESULT GetPrivateData( REFGUID refguid,void* pData,DWORD* pSizeOfData);
		HRESULT FreePrivateData( REFGUID refguid);
		DWORD SetPriority( DWORD PriorityNew);
		DWORD GetPriority();
		void PreLoad();
		D3DRESOURCETYPE GetType();
		
		/*** IDirect3DBaseTexture9 methods ***/
		DWORD SetLOD( DWORD LODNew);
		DWORD GetLOD();
		DWORD GetLevelCount();
		HRESULT SetAutoGenFilterType( D3DTEXTUREFILTERTYPE FilterType);
		D3DTEXTUREFILTERTYPE GetAutoGenFilterType();
		void GenerateMipSubLevels();
		
		/*** IDirec3DVolumeTexture9 methods***/
		HRESULT GetLevelDesc( UINT Level,D3DVOLUME_DESC *pDesc);
		HRESULT GetVolumeLevel( UINT Level,IDirect3DVolume9** ppVolumeLevel);
		HRESULT LockBox( UINT Level,D3DLOCKED_BOX* pLockedVolume,CONST D3DBOX* pBox,DWORD Flags);
		HRESULT UnlockBox( UINT Level);
		HRESULT AddDirtyBox( CONST D3DBOX* pDirtyBox);
	
		
		// |≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈• Additional methods •≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈|

		void					BindTexture();
		// Gives back the pointer to the local image of a level.
		void*					GetLocalImage(UINT in_lLevel) { return ((mVolumes[in_lLevel])->GetLocalImage()) ; }
		// Sets the local image of a mip level
		void					SetLocalImage(UINT in_lLevel, void *in_pData) { (mVolumes[in_lLevel])->SetLocalImage(in_pData); }
		// Gives back the texture id.
		GLuint					GetGLHandle() { return m_lGlHandle; }
		// Returns the Device pointer associated with this texture
		IDirect3DDevice9 *		GetDevice() { return m_pDevice; }
		// Returns the image width of a mip level
		UINT					GetWidth(UINT in_lLevel) { return m_lWidth[in_lLevel]; }
		// Returns the image height of a mip level
		UINT					GetHeight(UINT in_lLevel) { return m_lHeight[in_lLevel]; }
		// Returns the Format of the texture
		D3DFORMAT				GetFormat() { return m_Format; }
	
		CDGL_IDirect3DVolume9 * CreateVolume(UInt32, UInt32, UInt32, UInt32);	
	
		ITexture 				GetSmartTexture();
	
	
	private:
		
		IDirect3DDevice9		*m_pDevice;
		UINT					*m_lWidth;
		UINT					*m_lHeight;
		UINT					*m_lDepth;
		UINT					m_lLevels;
		DWORD					m_dwUsage;
		D3DFORMAT				m_Format;
		D3DPOOL					m_Pool;
		DWORD					m_dwLod;
		DWORD					m_dwPriority;
		int						m_lRefCount;

		GLuint					m_lGlHandle;
		GLint					m_lInternalFmt;
		GLenum					m_TextureFmt;
		GLenum					m_TextureType;

		int						m_lPitch;
		bool					*m_abTextureLoaded; 
		bool					m_bAutoGenMipmaps; 
	
		CDGL_IDirect3DVolume9	**mVolumes;
	
	
		// |≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈• SMARTDX •≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈|
		ITexture 				mTexture;
	
};

#endif //__CDGL_IDIRECT3DVOLUMETEXTURE9_H__

